implementation module Menu0

import ioTypes, clCrossCall

//	Operations on unknown MenuIds/MenuItemIds are ignored.

/*	Enabling and Disabling of the MenuSystem. When the menu system is enabled
	the previously selectable menus and menu items will become selectable again.
	Operations on a disabled menu system take effect when the menu system is
	re-enabled. */
EnableMenuSystem  :: !(IOState s) -> IOState s
EnableMenuSystem io = finalio
where
	io2		 =  ChangeMenuState (EnableMenuBar True) io
	finalio  =  ChangeOs WinDrawMenuBar io2 

DisableMenuSystem   :: !(IOState s) -> IOState s
DisableMenuSystem io = finalio
where
	io2		 =  ChangeMenuState (EnableMenuBar False) io
	finalio  =  ChangeOs WinDrawMenuBar io2 

EnableMenuBar :: !Bool  !(MAdmin s) !OS -> (!Bool, !MAdmin s, !OS)
EnableMenuBar onoff (Menu madmin=:{ mkind = MenuBarK }) os
	= (False, Menu { madmin & menabled = onoff }, os)
EnableMenuBar onoff menu=:(Menu madmin=:{ mkind = PullDownK }) os
	= (False, Menu madmin,	WinChangeMenuAbility madmin.mparent madmin.mpos (onoff && madmin.menabled) os )
EnableMenuBar onoff menu os  = (False, menu, os)

/*  Enabling and disabling of menus. Disabling a menu causes its
    contents to be unselectable. Enabling a disabled menu which
    contents was partially selectable before disabling causes only the
    previously selectable items to become selectable again.
*/
EnableMenus ::   ![MenuId] !(IOState s) -> IOState s
EnableMenus ids io = finalio
where
	io2		 =  ChangeMenuState (EnablePullDowns True ids) io
	finalio  =  ChangeOs WinDrawMenuBar io2 

DisableMenus    ::   ![MenuId] !(IOState s) -> IOState s
DisableMenus ids io = finalio
where
	io2		 =  ChangeMenuState (EnablePullDowns False ids) io
	finalio  =  ChangeOs WinDrawMenuBar io2

EnablePullDowns :: !Bool ![MenuItemId] !(MAdmin s) !OS -> (!Bool, !MAdmin s, !OS)
EnablePullDowns onoff ids menu=:(Menu madmin=:{ mkind = PullDownK }) os
	|  isMember madmin.mid ids = (False, Menu { madmin & menabled = onoff }, 
										WinChangeMenuAbility madmin.mparent madmin.mpos onoff os )
    |  otherwise               = (False, menu, os)
EnablePullDowns onoff ids menu os  = (False, menu, os)

/*	Addition and removal of menu items in MenuItemGroups.
	InsertMenuItems inserts menu items before the item with the specified
	index, AppendMenuItems inserts them after that item. Items are
	numbered starting from one. Indices smaller than one resp. greater
	than the number of items in the group cause the elements to be
	inserted before the first resp. after the last item of the group.
	Only (Check)MenuItems and MenuSeparators are added to a MenuItemGroup.
	RemoveMenu(Group)Items only works on items that are in a MenuItemGroup.
	RemoveMenuGroupItems removes those items of the specified MenuItemGroup
	given the indices. Indices are numbered starting from one. If an index
	is invalid (less than one or larger than the amount of items), no item
	is removed for that index. */

InsertMenuItems :: !MenuItemGroupId !Int ![MenuElement s (IOState s)]
    !(IOState s) -> IOState s
InsertMenuItems groupid pos elements iostate = UpdateMenuState (InsertItems groupid pos elements) iostate


AppendMenuItems :: !MenuItemGroupId !Int ![MenuElement s (IOState s)]
    !(IOState s) -> IOState s
AppendMenuItems groupid pos elements iostate = UpdateMenuState (InsertItems groupid (pos+1) elements) iostate


InsertItems :: !MenuItemGroupId !Int ![MenuElement s (IOState s)] !(MAdmin s) OS -> (!Bool, !MAdmin s, !OS)
InsertItems groupid index elements menu=:(Menu madmin=:{ mkind = ItemGroupK }) os
	|  madmin.mid == groupid  =  ( True, Menu newmenu, newos )
	with
	   noofitems      =  length madmin.melements
	   correctindex 
	     |  index < 1			=  1
		 |  index > noofitems	=  noofitems + 1
		 |  otherwise           =  index
	   insertpos      =  madmin.mpos + correctindex - 1
	   (insertedelements,newos)
					  =  InsertElements (filter IsGroupItem elements) madmin.mparent insertpos os
	   (beforeelements, afterelements)
					  =  splitAt (correctindex -1) madmin.melements
	   newelements    =  beforeelements ++ insertedelements ++ afterelements
	   newmenu        =  { madmin & melements = newelements }

	|  otherwise              =  ( False, menu, os )
InsertItems groupid index elements menu os 
							  =  ( False, menu, os )


RemoveMenuItems :: ![MenuItemId] !(IOState s) -> IOState s
RemoveMenuItems ids iostate = UpdateMenuState (RemoveByIds ids) iostate
where
	RemoveByIds :: [MenuItemId] (MAdmin s) OS -> (Bool, MAdmin s, OS)
	RemoveByIds ids (Menu madmin=:{ mkind = ItemGroupK }) os
		=  (False, Menu newadmin, newos)
	where
		(newelements,newos) = RemoveElements (ById ids) madmin.melements os
		newadmin            = { madmin & melements = newelements }

		ById :: [MenuItemId] (ItemAdmin s) -> Bool
		ById ids admin = isMember admin.iid ids

	RemoveByIds ids othermenu os = (False, othermenu, os)


RemoveMenuGroupItems    :: !MenuItemGroupId ![Int] !(IOState s) -> IOState s
RemoveMenuGroupItems groupid poss iostate = UpdateMenuState (RemoveByPoss groupid poss) iostate
where
	RemoveByPoss :: MenuItemGroupId [Int] (MAdmin s) OS -> (Bool, MAdmin s, OS)
	RemoveByPoss groupid poss (Menu madmin=:{ mkind = ItemGroupK }) os
	  | madmin.mid == groupid  = ( True, Menu newadmin, newos ) 
  	  with
		(newelements,newos) = RemoveElements (ByPos poss) madmin.melements os
		newadmin            = { madmin & melements = newelements }
	    
		ByPos :: [Int] (ItemAdmin s) -> Bool
		ByPos poss admin =  isMember (admin.ipos - madmin.mpos +1) poss

	RemoveByPoss groupid poss menu os = (False, menu, os)

RemoveElements :: !((ItemAdmin s) -> Bool) ![MAdmin s] !OS -> (![MAdmin s], !OS)
RemoveElements pred [] os
	= ( [], os )
RemoveElements pred [ Item iadmin: rest] os
	| pred iadmin   
		= RemoveElements pred rest newos
		with  newos  =  WinRemoveMenuItem iadmin.iparent iadmin.ihandle os
	| otherwise
		= ( [ Item iadmin: restdone] , finalos)
		with  (restdone, finalos) = RemoveElements pred rest os

RemoveElements pred othermenu os = abort "How come an item group got non-item elements?"




EnableMenuItems :: ![MenuItemId]   !(IOState s) -> IOState s
EnableMenuItems ids io  =  ChangeMenuState  (EnableItems True ids) io

DisableMenuItems  ::  ![MenuItemId]   !(IOState s) -> IOState s
DisableMenuItems ids io  =  ChangeMenuState  (EnableItems False ids) io


EnableItems :: !Bool ![MenuItemId] !(MAdmin s) !OS -> (!Bool, !MAdmin s, !OS)
EnableItems onoff ids item=:(Item iadmin) os 
	|  isMember iadmin.iid ids  = (False, Item {iadmin & ienabled = onoff }, 
										WinChangeItemAbility iadmin.iparent iadmin.ihandle onoff os)
	|  otherwise                = (False, item, os) 
EnableItems onoff ids menu=:(Menu madmin=:{ mkind = SubMenuK }) os
	|  isMember madmin.mid ids	=  (False, Menu { madmin & menabled = onoff }, 
										WinChangeMenuAbility madmin.mparent madmin.mpos onoff os )
    |  otherwise				= (False, menu, os)
EnableItems onoff ids othermenu os 
	=  (False, othermenu, os)


MarkMenuItems		::  ![MenuItemId]   !(IOState s) -> IOState s
MarkMenuItems ids iostate = ChangeMenuState (MarkMenu True ids) iostate


UnmarkMenuItems		::  ![MenuItemId]   !(IOState s) -> IOState s
UnmarkMenuItems ids iostate = ChangeMenuState (MarkMenu False ids) iostate


MarkMenu :: !Bool ![MenuItemId] !(MAdmin s) !OS -> (!Bool, !MAdmin s, !OS)
MarkMenu onoff ids item=:(Item iadmin=:{ ikind = CheckItemK }) os
	|  isMember iadmin.iid ids  =  (False, Item { iadmin & imarked = onoff }, WinChangeMenuItemCheck iadmin.iparent iadmin.ihandle onoff os )
    |  otherwise                =  (False, item, os) 
MarkMenu onoff ids admin os		=  (False, admin, os)



ChangeMenuItemTitles    ::  ![(MenuItemId, ItemTitle)] !(IOState s) -> IOState s
ChangeMenuItemTitles pairs io = ChangeMenuState (ChangeTitles pairs) io
where
	ChangeTitles :: ![(MenuItemId, ItemTitle)] (MAdmin s) OS -> (Bool, MAdmin s, OS)
	ChangeTitles pairs item=:(Item iadmin) os 
		=  case FindIdInPairs iadmin.iid pairs of
				Nope		-> (False, item, os)
				OK newtitle -> (False, Item {iadmin & ititle = newtitle}, newos )
				where
					text	= case iadmin.ikey of
						Key keycode -> newtitle +++ "\tCtrl+" +++ toString (toUpper keycode)
						NoKey		-> newtitle
					newos   = WinModifyMenuItem iadmin.ihandle text iadmin.ienabled iadmin.imarked iadmin.iparent os
	ChangeTitles pairs menu=:(Menu madmin=:{ mkind = SubMenuK }) os 
		=  case FindIdInPairs madmin.mid pairs of
				Nope		-> (False, menu, os)
				OK newtitle -> (False, Menu {madmin & mtitle = newtitle},
									WinModifyMenu newtitle madmin.menabled madmin.mhandle madmin.mparent madmin.mpos os)
	ChangeTitles pairs othermenu os =  (False, othermenu, os)



ChangeMenuItemFunctions :: ![(MenuItemId, MenuFunction s (IOState s))]
                           !(IOState s) -> IOState s
ChangeMenuItemFunctions pairs io = ChangeMenuState (ChangeFuncts pairs) io
where
	ChangeFuncts :: ![(MenuItemId, MenuFunction s (IOState s))] (MAdmin s) OS -> (Bool, MAdmin s, OS)
	ChangeFuncts pairs item=:(Item iadmin) os 
		=  case FindIdInPairs iadmin.iid pairs of
				Nope     -> (False, item, os)
				OK funct -> (False, Item { iadmin & ifunction = funct }, os) 
	ChangeFuncts pairs othermenu     os = (False, othermenu, os)




FindIdInPairs :: Int [(Int, a)] -> Perhaps a
FindIdInPairs id [] = Nope
FindIdInPairs id [(id2, a):rest]
	| id == id2  =  OK a
	| otherwise  =  FindIdInPairs id rest




InitMenu :: !(IOSystem s (IOState s)) !(IOadmin s) !OS -> ( !IOadmin s, !OS)
InitMenu defs  admin=:{  io_menuState = OK m } os = abort "Can only init menus when there is no menu active"                
InitMenu [  MenuSystem  menudefs : rest ] adm os = ( {adm & io_menuState = newmenu}, newos)
where
	(newmenu, newos) = CreateMenuBar menudefs os 
InitMenu [  otherkind			 : rest ] adm os = InitMenu rest adm os
InitMenu []								  adm os = ( adm, os )


CreateMenuBar :: ![MenuDef s (IOState s)] !OS -> ( Perhaps (MenuWinAdmin s), OS)
CreateMenuBar [] os  = ( Nope, os )
CreateMenuBar mns os = ( OK { mbwinhandle = winhandle,
						      mbmenu      = recalcedmenubar  }, finalos )
where
	( barhandle, os2 )     =  WinCreateMenuBarHandle os
	menuinfos              =  [ (id, title, state, elements) \\ 
									(PullDownMenu id title state elements) <- mns ]
	( menus, os3 )         =  smap (CreatePopupMenu barhandle PullDownK) menuinfos os2
	title				   =  "Clean Application"
	menubar                =  Menu { mkind     = MenuBarK,
									 mid       = -1,
									 mtitle    = title,
									 menabled  = True,
									 mhandle   = barhandle,
									 melements = menus,
									 mparent   = 0,
									 mpos      = 0
									}  
	recalcedmenubar        =  RecalcPositions menubar
	os4					   =  RecreateShortcuts recalcedmenubar os3
	( winhandle, finalos ) =  WinCreateMenuWindow barhandle title os4

 

CreateMenuElement :: !HMENU !(MenuElement s (IOState s)) !OS -> (MAdmin s,OS)
CreateMenuElement supermenu (MenuItem id title key state function) os
	= (admin, newos)
where
	pkey           =  ProperKey key
	(hitem,newos)  =  WinAppendMenuItem (MenuItemText title pkey) (Enabled state) False supermenu os
    admin          =  MenuItemAdmin ItemK id hitem title pkey state NoMark function supermenu
CreateMenuElement supermenu (CheckMenuItem id title key state markstate function) os
	= (admin, newos)
where
	pkey          =  ProperKey key
	(hitem,newos) =  WinAppendMenuItem (MenuItemText title pkey) (Enabled state) (Marked markstate) supermenu os
    admin         =  MenuItemAdmin CheckItemK id hitem title pkey state markstate function supermenu
CreateMenuElement supermenu MenuSeparator os 
	= ( Separator, WinAppendSeparator supermenu os)
CreateMenuElement supermenu (SubMenuItem id title state elements) os
    =  CreatePopupMenu supermenu SubMenuK (id, title, state, elements) os
CreateMenuElement supermenu (MenuItemGroup id elements) os
    =  ( groupadmin, os2)
where
	filtereditems     =  filter IsGroupItem elements
	(itemadmins,os2)  =  smap (CreateMenuElement supermenu) filtereditems os
	groupadmin		  =  Menu { mkind     = ItemGroupK,
						        mid       = id,
						        mtitle    = "",
						        melements = itemadmins,
						        menabled  = True,
						        mhandle   = 0,
								mparent   = supermenu,
								mpos      = 0
						      }
CreateMenuElement supermenu (MenuRadioItems id elements) os
    =  ( groupadmin, os2)
where
    matchingids       =  filter ((==) id) [ elid \\ (MenuRadioItem elid _ _ _ _) <- elements ]
	defid             =  case (matchingids, elements) of
							( [],  [] )								-> 0
							( [],  [ MenuRadioItem i _ _ _ _ :_] )	-> i
							( [i], _ )								-> i
							( _ ,  _ )								-> abort "multiple radio menuitems initially selected"
	(itemadmins,os2)  =  smap (CreateRadioElement supermenu defid) elements os
	groupadmin        = Menu { mkind     = RadioGroupK,
						       mid       = defid,
						       mtitle    = "",
						       melements = itemadmins,
						       menabled  = True,
						       mhandle   = 0,
							   mparent   = supermenu,
							   mpos      = 0 
						     }


CreatePopupMenu :: !HMENU !MenuKind !(!Int, !String, !SelectState, ![MenuElement s (IOState s)]) !OS -> (MAdmin s, OS)
CreatePopupMenu supermenu kind (id, title, state, els) os
	 = (madmin, finalos)
where 
	enabled                 =  Enabled state
	( menuhandle, os2 )     =  WinCreatePopupMenuHandle os
	( elements, os3 )       =  smap (CreateMenuElement menuhandle) els os2
    finalos				    =  WinAppendMenu title enabled menuhandle supermenu os3
	madmin			  	    =  Menu { mkind     = kind,
									  mid       = id,
									  mtitle    = title,
									  melements = elements,
									  menabled  = enabled,
									  mhandle   = menuhandle,
									  mparent   = supermenu,
									  mpos      = 0
									}

CreateRadioElement :: !HMENU !MenuItemId !(RadioElement s (IOState s)) !OS -> (MAdmin s, OS)
CreateRadioElement supermenu defid (MenuRadioItem id title key state function) os
	=  (admin, os2)
where
	pkey	      =  ProperKey key
    text          =  MenuItemText title pkey
	markstate     = if (id == defid)
								 Mark
					/* else */   NoMark
	(hitem, os2)  =  WinAppendMenuItem text (Enabled state) (Marked markstate) supermenu os
    admin         =  MenuItemAdmin RadioItemK id hitem title pkey state markstate function supermenu




  //-------------------------------//
 //  Event Handling               //
//-------------------------------//




HandleMenuEvent :: !CrossCallInfo !*s !(IOadmin *s) !OS -> ( Bool, CrossCallInfo, *s, IOadmin *s, OS)
HandleMenuEvent (CcWmCOMMAND, hitem, _,_,_,_,_) s adm os
	=  (True, donecci, dones, doneadmin, doneos)  
where
	donecci     =  ( CcRETURN0, 0,0,0,0,0,0 )
	iostate     =  PackIOState adm os
	(dones, doneiostate)
				=  case adm.io_menuState of 
						Nope -> ( s, iostate)
						OK menuwinadm 
							 -> DoMenuFunction hitem menuwinadm.mbmenu s iostate
	( doneadmin, doneos )
				=  UnpackIOState doneiostate
HandleMenuEvent cci s adm os = (False, cci, s, adm, os)


DoMenuFunction :: !HITEM !(MAdmin *s) !*s !(IOState *s) -> (*s, IOState *s)
DoMenuFunction hitem menu s iostate = (finals, finaliostate)
where
	( finals, finaliostate) 
		= case FindMenuItemWithHandle hitem menu of
			OK itemadm  
				->  case itemadm.ikind of
						RadioItemK    
							  -> Iprint ("Menu item \"" +++ itemadm.ititle +++ "\".") itemadm.ifunction s (SelectMenuRadioItemWithHandle hitem iostate)
						other -> Iprint ("Menu item \"" +++ itemadm.ititle +++ "\".") itemadm.ifunction s iostate
			Nope ->  abort ("[HandleMenuEvent] got unknown command id:" +++ toString hitem)




FindMenuItemWithHandle :: !HITEM !(MAdmin s) -> Perhaps (ItemAdmin s)
FindMenuItemWithHandle hitem Separator    = Nope
FindMenuItemWithHandle hitem (Item itemadm)
	| itemadm.ihandle == hitem	= OK itemadm
	| otherwise                 = Nope
FindMenuItemWithHandle hitem (Menu menuadm)  = finditem hitem menuadm.melements
where
    finditem :: !HITEM ![MAdmin s] -> Perhaps (ItemAdmin s)
	finditem hitem []                = Nope
	finditem hitem [element : rest]  = case FindMenuItemWithHandle hitem element of
				  							  Nope  ->  finditem hitem rest
											  found ->  found



  //-------------------------------//
 //  Support for deltaMenu        //
//-------------------------------//


ChangeMenu :: ( (MAdmin s) OS -> (Bool, MAdmin s, OS) ) !(MAdmin s) !OS -> (Bool, MAdmin s, OS)
ChangeMenu f m=:(Menu madmin) os
	| didit		=  (didit, Menu newmenuadmin, doneos)
	| otherwise =  (didelements, Menu newadminwithelements, doneelementsos)
		with (didelements, newelements, doneelementsos) = ChangeMenus f newmenuadmin.melements doneos
		     newadminwithelements  =  { newmenuadmin & melements = newelements } 
where
	(didit, Menu newmenuadmin, doneos)  =  f m os
ChangeMenu f item os = f item os
	 
	   

ChangeMenus :: ( (MAdmin s) OS -> (Bool, MAdmin s, OS) ) ![MAdmin s] !OS -> (Bool,[MAdmin s], OS)
ChangeMenus f [] os				 =  (False, [], os)
ChangeMenus f [element:rest] os 
	| elementdone	=  ( True, [doneelement:rest], elementdoneos )   
	| otherwise		=  ( restdone, [doneelement: donerest], restdoneos )
		with  (restdone, donerest, restdoneos) = ChangeMenus f rest elementdoneos
where
	(elementdone, doneelement, elementdoneos) = ChangeMenu f element os

ChangeMenuState :: ( (MAdmin s) OS -> (Bool, MAdmin s, OS) ) !(IOState s) -> IOState s
ChangeMenuState f iostate = finaliostate
where
	( ioadmin, os )			
		=  UnpackIOStateWithCheck iostate
    ( newioadmin, newos )		
		=  case ioadmin.io_menuState of
				 Nope			 ->  ( ioadmin, os )
				 OK menuwinadmin ->  ({ioadmin & io_menuState = OK newwinadmin }, newos )
					where (_,newmenuadmin,newos ) =  ChangeMenu f menuwinadmin.mbmenu os
						  newwinadmin             =  { menuwinadmin & mbmenu = newmenuadmin }   
	finaliostate
		=  PackIOState newioadmin newos					  

UpdateMenuState :: ( (MAdmin s) OS -> (Bool, MAdmin s, OS) ) !(IOState s) -> IOState s
UpdateMenuState f iostate = finaliostate
where
	( ioadmin, os )			
		=  UnpackIOStateWithCheck iostate
    ( newioadmin, newos )		
		=  case ioadmin.io_menuState of
				 Nope			 ->  ( ioadmin, os )
				 OK menuwinadmin ->  ({ioadmin & io_menuState = OK newwinadmin }, newos )
					where (_,menuadmin1,os2 )  =   ChangeMenu f menuwinadmin.mbmenu os
						  newmenuadmin		   =   RecalcPositions menuadmin1   
						  newwinadmin		   =  { menuwinadmin & mbmenu = newmenuadmin }   
						  newos                =  RecreateShortcuts newmenuadmin os2
	finaliostate
		=  PackIOState newioadmin newos					  


/*	SelectMenuRadioItem marks the indicated MenuRadioItem and unmarks the
	currently marked MenuRadioItem in the group. */
SelectMenuRadioItem :: !MenuItemId !(IOState s) -> IOState s
SelectMenuRadioItem id iostate = SelectMenuRadioItemWithPred (\it -> it.iid == id) iostate 

SelectMenuRadioItemWithHandle hitem iostate  = SelectMenuRadioItemWithPred (\it -> it.ihandle == hitem) iostate 

SelectMenuRadioItemWithPred :: !((ItemAdmin s)->Bool) !(IOState s) -> IOState s
SelectMenuRadioItemWithPred pred iostate = ChangeMenuState (SelectRadioItem pred) iostate 
where
	SelectRadioItem ::  !((ItemAdmin s)->Bool) !(MAdmin s) !OS -> (Bool, MAdmin s, OS)
	SelectRadioItem pred m=:(Menu adm=:{ mkind = RadioGroupK }) os
	  = case FindItWithPredicate pred adm.melements of
	       Nope  -> ( False, m, os )
		   OK id -> ( True, (Menu newadm), newos ) 
						where
							(elements2,os2)    =  smap (turnoff adm.mid) adm.melements os
							(elements3,newos)  =  smap (turnon  pred)      elements2    os2
							newadm             = { adm & melements = elements3, mid = id }

							turnoff id i=:(Item ia) os 
								| id == ia.iid    = (Item {ia & imarked = False}, 
														WinChangeMenuItemCheck ia.iparent ia.ihandle False os)  
								| otherwise       = (i, os)
							turnoff id menu os    = abort "Turnoff called for non-item"

							turnon  pred i=:(Item ia) os 
								| pred ia    = (Item {ia & imarked = True}, 
												WinChangeMenuItemCheck ia.iparent ia.ihandle True os)  
								| otherwise  = (i, os)
							turnon pred menu os     = abort "Turnon called for non-item"
	where		
		FindItWithPredicate pred [] = Nope
        FindItWithPredicate pred [(Item i):rest]
		   | pred i  =  OK i.iid 
		             =  FindItWithPredicate pred rest
		FindItWithPredicate pred [i:rest]
		             =  FindItWithPredicate pred rest



	SelectRadioItem pred madmin os = (False, madmin, os)


InsertElements :: [MenuElement s (IOState s)] HMENU Int OS -> ([MAdmin s], OS)
InsertElements [] menu pos os = ([], os)
InsertElements [ element : rest ] menu pos os 
	| IsGroupItem element  =  ( [admin : restadmin], finalos )
	with
		( admin, newos )       =  InsertElement  element menu pos os
		( restadmin, finalos)  =  InsertElements rest    menu (pos+1) newos 
	| otherwise	 =  InsertElements rest menu pos os


InsertElement :: (MenuElement s (IOState s)) HMENU Int OS -> (MAdmin s, OS) 
InsertElement (MenuItem id title key state function) menu pos os
	= (admin, newos)
where
	pkey            =  ProperKey key
	(hitem, newos)	=  WinInsertMenuItem (MenuItemText title pkey) (Enabled state) False menu pos os
    admin           =  MenuItemAdmin ItemK id hitem title pkey state NoMark function menu
InsertElement (CheckMenuItem id title key state markstate function) menu pos os 
	= (admin, newos)
where
	pkey            =  ProperKey key
	(hitem, newos)  =  WinInsertMenuItem (MenuItemText title pkey) (Enabled state) (Marked markstate) menu pos os
    admin           =  MenuItemAdmin CheckItemK id hitem title pkey state markstate function menu
InsertElement MenuSeparator  menu pos os
	= ( Separator, WinInsertSeparator menu pos os)
InsertElement othermenu menu pos os = abort "InsertElement should only get Items, CheckItems or Separators"



  //-------------------------------//
 //  Some helper functions        //
//-------------------------------//


RecalcPositions :: (MAdmin s) -> MAdmin s 
RecalcPositions admin = newadmin
where
	( _, [ newadmin:_] )  =  Recalc 0 [admin]

	Recalc :: Int [MAdmin s] -> (Int, [MAdmin s])
	Recalc pos [] = (pos, [])
	Recalc pos [menu:rest] = (finalpos, [donemenu:donerest] ) 
	where
		(newpos, donemenu)	 
			=  case menu of
					Separator    -> (pos+1, Separator)
					Item iadmin  -> (pos+1, Item { iadmin & ipos = pos })  
					Menu madmin  -> (newpos, Menu { madmin & mpos = pos, melements = newelements })
						where
							(newpos, elementpos) 
								=  case madmin.mkind of
										ItemGroupK   ->  ( afterelements, pos )
										RadioGroupK  ->  ( afterelements, pos )
										other        ->  ( pos + 1, 0 )
							(afterelements, newelements) 
								=  Recalc elementpos madmin.melements
		(finalpos, donerest) = Recalc newpos rest


RecreateShortcuts :: (MAdmin s) OS -> OS
RecreateShortcuts admin os = newos
where
	shortcuts		=  GetShortcuts [admin]
	noofcuts		=  length shortcuts
	(arrayptr,os2)	=  WinAllocShortcutTable noofcuts os
	os3             =  FillShortcutTable shortcuts arrayptr 0 os2
	newos           =  WinActivateShortcutTable arrayptr noofcuts os3

	GetShortcuts :: [MAdmin s] -> [(Char, HITEM)]
	GetShortcuts [Menu madmin:rest] 
		= GetShortcuts madmin.melements ++ GetShortcuts rest
	GetShortcuts [Item iadmin:rest] 
		= case iadmin.ikey of
			NoKey -> GetShortcuts rest
			Key c -> [ (c, iadmin.ihandle): GetShortcuts rest ]					
	GetShortcuts [Separator:rest]
		= GetShortcuts rest
	GetShortcuts [] = []

	FillShortcutTable :: [(Char, HITEM)] ACCLPTR Int OS ->OS
	FillShortcutTable []			acc pos os = os
	FillShortcutTable [(c,id):rest] acc pos os = FillShortcutTable rest acc (pos+1) newos
	where
		newos  =  WinCopyShortcutToTable c id pos acc os


IsGroupItem :: !(MenuElement s io) -> Bool
IsGroupItem (MenuItem      _ _ _ _ _)   = True
IsGroupItem (CheckMenuItem _ _ _ _ _ _) = True
IsGroupItem MenuSeparator               = True
IsGroupItem _	                        = False


MenuItemText :: ItemTitle KeyShortcut -> String
MenuItemText title key 
	= case key of
		Key keycode -> title +++ "\tCtrl+" +++ toString (toUpper keycode)
		NoKey		-> title

 
MenuItemAdmin :: !MenuItemKind !MenuItemId !HITEM !ItemTitle !KeyShortcut !SelectState !MarkState
				  (MenuFunction s (IOState s)) !HMENU -> MAdmin s
MenuItemAdmin kind id hitem title key selectstate markstate function menu 
	= Item { ikind     = kind,
				 	   iid       = id,
					   ihandle   = hitem,
				 	   ititle    = title,
	                   ikey      = key,
					   ienabled  = enabled,
					   imarked   = marked,
					   ifunction = function,
					   iparent   = menu,
					   ipos      = 0
				     }
where
	enabled = Enabled selectstate
	marked  = Marked  markstate

ProperKey :: KeyShortcut -> KeyShortcut
ProperKey NoKey = NoKey
ProperKey (Key c)
	|  c >= 'a' && c <= 'z'  = Key (toUpper c) 
	|  c >= 'A' && c <= 'Z'  = Key c
	|  c >= '0' && c <= '9'  = Key c
	|  isMember c otherchars = Key c
	                         = NoKey
where
  otherchars = ['[', ']', ';', '\'', '-', '=', ',', '.' ,'/' ,'\\']






